<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('block_info', $version_num);
	bodyNavigation('block_info');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

/*
 * Get the QuickStats values of the blocking stats
 */
$sql = "SELECT *
			FROM " . $db_table_prefix . "quickstats
				WHERE id = 2
					";
$result = mysql_query($sql);
$row = mysql_fetch_array($result);
	$last_update_time = $row['last_update_time'];
		$date = date('M jS, Y', $last_update_time);
		$time = date('g:i:s A', $last_update_time);
	$block_count_today = $row['block.today.total'];
	$block_visitors_today = $row['block.today.unique'];
	$block_count_yesterday = $row['block.yesterday.total'];
	$block_visitors_yesterday = $row['block.yesterday.unique'];
	$block_count_week = $row['block.week.total'];
	$block_visitors_week = $row['block.week.unique'];

?>
<div id="side-bar">
	<div>
		<p class="sideBarTitle">Blocked Information</p>
		<ul>
			<li><a href="#blocked_stats">&rsaquo; Blocked Stats</a></li>
			<li><a href="#recent_blocks">&rsaquo; Recent Blocks</a></li>
		</ul>
	</div>
</div>

<div id="main-copy">
	<h1 id="blocked_stats">Blocked Stats</h1>
	<p>The following table shows the number of pages and unique visitors for which the script blocked ads.</p>
	<div align="center">
		<table summary="overview" width="65%" id="greytable">
			<thead id="greythead">
				<tr>
					<th scope="col" width="15%">Date</th>
					<th scope="col" width="25%">Total Blocks</th>
					<th scope="col" width="25%">Unique Visitors Blocked</th>
				</tr>
			</thead>
			<tbody id="greytbody">
				<tr>
					<td><strong>Today</strong></td>
					<td align="center"><?php echo number_format($block_count_today); ?></td>
					<td align="center"><?php echo number_format($block_visitors_today); ?></td>
				</tr>
				<tr class="odd">
					<td><strong>Yesterday</strong></td>
					<td align="center"><?php echo number_format($block_count_yesterday); ?></td>
					<td align="center"><?php echo number_format($block_visitors_yesterday); ?></td>
				</tr>
				<tr class="odd">
					<td><strong>This Week</strong></td>
					<td align="center"><?php echo number_format($block_count_week); ?></td>
					<td align="center"><?php echo number_format($block_visitors_week); ?></td>
				</tr>
			</tbody>
		</table>
		<br />
		These stats were last updated at <?php echo "<strong>" . $time . "</strong>" . " on <strong>" . $date . "</strong>"; ?>.  Click <a href="./update_stats.php?update=blocks&amp;ref=<?php echo $_SERVER['REQUEST_URI']; ?>">here</a> to update them.
	</div>

	<h1 id="recent_blocks">Recent Blocks</h1>
	<p>The following table shows the most recent successful blocks.</p>

	<div align="center">
<?php
/*
 * Start pagination code
 */
	$sql = "
			SELECT COUNT(DISTINCT visitor_ip)
				FROM " . $db_table_prefix . "blocklogs
					";

	$result = mysql_query($sql);
		$row = mysql_fetch_array($result);
		$numrows = $row['COUNT(DISTINCT visitor_ip)'];

	if (isset($_GET['pageno']) && !empty($_GET['pageno'])) {
	   $pageno = $_GET['pageno'];
	} else {
	   $pageno = 1;
	}

	if (isset($_GET['sortnum']) && !empty($_GET['sortnum'])) {
		$rows_per_page = $_GET['sortnum'];
	} else {
		$rows_per_page = 10;
	}

	$lastpage = ceil($numrows/$rows_per_page);
	if ($lastpage == 0) $lastpage = 1;

	$pageno = (int)$pageno;

	$limit = 'LIMIT ' .($pageno - 1) * $rows_per_page .',' .$rows_per_page;

	if ($pageno <= 1) {
		echo " FIRST PREV ";
	} else {
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=1&amp;sortnum=$rows_per_page#recent_blocks'>FIRST</a> ";
		$prevpage = $pageno - 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$prevpage&amp;sortnum=$rows_per_page#recent_blocks'>PREV</a> ";
	}

	echo " ( Page $pageno of $lastpage ) ";

	if ($pageno >= $lastpage) {
		echo " NEXT LAST ";
	} else {
		$nextpage = $pageno + 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$nextpage&amp;sortnum=$rows_per_page#recent_blocks'>NEXT</a> ";
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$lastpage&amp;sortnum=$rows_per_page#recent_blocks'>LAST</a> ";
	}
?>
	</div>
	<br />

	<?php if ($numrows > 0) { ?>

			<table summary="recent_blocks" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Date</th>
						<th scope="col">Time</th>
						<th scope="col">IP Address</th>
						<th scope="col">Total Blocks</th>
						<th scope="col">Blocked Ads URL</th>
					</tr>
				</thead>

				<tbody id="greytbody">

				<?php
					/*
					Perform the query on the database to grab the rows.
					*/
					$sql = "
							SELECT id, visitor_ip, blocked_url, COUNT(visitor_ip) as instance_count, MAX(timestamp) as timestamp
								FROM " . $db_table_prefix . "blocklogs
									GROUP BY visitor_ip
										ORDER BY timestamp desc
											$limit
												";
						$result = mysql_query($sql) or die(mysql_error());
							/*
							Start the loop to display them.  In this loop, the script creates
							a new table row for each entry it finds from the database.
							*/
							while($row = mysql_fetch_array($result)) {
								$id = $row['id'];
								$timestamp = $row['timestamp'];
									// Convert that UNIX timestamp to something a little more useable
									$date = date('M j, Y', $timestamp);
									$time = date('g:i:s a', $timestamp);
								$visitor_ip = $row['visitor_ip'];
								$blocked_url = urldecode($row['blocked_url']);
								$instance_count = $row['instance_count'];
						?>
								<tr class="odd">
									<td><?php echo $date; ?></td>
									<td><?php echo $time; ?></td>
									<td><?php echo $visitor_ip; ?></td>
									<td><a href="./blocked_visitor.php?visitor_ip=<?php echo $visitor_ip; ?>"><?php echo $instance_count; ?></a></td>
									<td><?php echo shortenURL($blocked_url); ?></td>
								</tr>
						<?php } /* End the loop. */ ?>

				</tbody>
			</table>
	<?php } ?>

</div>
<?php bodyFooter('block_info', $start_time); ?>